
<?php
require_once __DIR__ . '/../config/db.php';

if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    die("Invalid application ID.");
}

$application_id = (int) $_GET['id'];

try {
    $stmt = $pdo->prepare("SELECT * FROM application_status_updates WHERE application_id = ? ORDER BY created_at ASC");
    $stmt->execute([$application_id]);
    $updates = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (empty($updates)) {
        echo "<p>هیچ گۆڕانکارییەک نەکراوە بۆ ئەم داواکارییە.</p>";
    } else {
        echo "<ol style='list-style: none; padding: 0;'>";

        for ($i = 0; $i < count($updates); $i++) {
            $row = $updates[$i];
            $startDate = new DateTime($row['created_at']);

            // Check if there's a "next" update to calculate how long this admin held it
            if (isset($updates[$i + 1])) {
                $endDate = new DateTime($updates[$i + 1]['created_at']);
                $interval = $startDate->diff($endDate)->days;
            } else {
                // If this is the latest step, show how many days until now
                $now = new DateTime();
                $interval = $startDate->diff($now)->days;
            }

            echo "<li style='margin-bottom: 15px; border: 1px solid #ccc; padding: 10px; border-radius: 10px;'>";
            echo "<strong>لەلایەن: </strong> " . htmlspecialchars($row['previous_receiver']) . "<br>";
            echo "<strong>بۆ:</strong> " . htmlspecialchars($row['new_receiver']) . "<br>";
            echo "<strong>بەرواری ناردن:</strong> " . $startDate->format('Y-m-d H:i') . "<br>";
            echo "<strong>ژمارەی ڕۆژ: </strong> " . $interval . " ڕۆژ<br>";
            echo "<strong>بڕیار: </strong> " . htmlspecialchars($row['decision']) . "<br>";
            echo "<strong>تێبینی:</strong> " . nl2br(htmlspecialchars($row['comment'])) . "<br>";
            echo "</li>";
        }

        echo "</ol>";
    }
} catch (PDOException $e) {
    echo "<p>هەڵە هەیە لە هێنانی زانیارییەکان: " . $e->getMessage() . "</p>";
}
?>
