<?php
require_once '../../config/db.php'; // Adjust path if needed

if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    die("Invalid application ID.");
}

$application_id = (int) $_GET['id'];

try {
    // Fetch the application by ID
    $stmt = $pdo->prepare("
    SELECT sa.*, u.email, u.department, u.role AS user_role
        FROM submitted_applications sa
        JOIN users u ON sa.user_id = u.id
        WHERE sa.id = ?

    ");
    $stmt->execute([$application_id]);
    $application = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$application) {
        die("Application not found.");
    }

 

} catch (PDOException $e) {
    die("Database error: " . $e->getMessage());
}
?>

<!DOCTYPE html>
<html lang="ku">
<head>
    <meta charset="UTF-8">
    <title>زانیاری دەربارەی داواکاری</title>
    <link rel="stylesheet" href="../../assets/css/main/infoAppSection.css?v=2">
    <style>
        .status.acceptAfterSolution { background: rgb(208, 255, 0); color: white; }
        .status.pending { background: rgb(0, 217, 255); color: white; }
        .status.not-seen { background: gray; color: white; }
        .status.done { background: green; color: white; }
        .form-textarea {
            width: 100%;
            padding: 10px;
            font-size: 14px;
            border: 1px solid #ccc;
            border-radius: 8px;
            background-color: #f0f0f0;
            resize: none;
        }
    </style>
</head>
<body>
<div class="container">
    <h1>زانیاری دەربارەی داواکاری</h1>

    <div class="info-row"><div class="info-label">ژمارە:</div><div class="info-value"><?= $application['id']; ?></div></div>
    <div class="info-row"><div class="info-label">ئیمەیڵ:</div><div class="info-value"><?= htmlspecialchars($application['email']); ?></div></div>
            <div class="info-row"><div class="info-label">بەڕێوبەراییەتی:</div><div class="info-value"><?= htmlspecialchars($application['department']); ?></div></div>

    <div class="info-row"><div class="info-label">ڕۆژ:</div><div class="info-value"><?= $application['created_at']; ?></div></div>
            <div class="info-row"><div class="info-label">هاتوو:</div><div class="info-value"><?= htmlspecialchars($application['sent_by']); ?></div></div>

    <div class="info-row"><div class="info-label">بار:</div>
        <div class="info-value">
            <span class="status <?= strtolower(str_replace(' ', '-', $application['status'])); ?>">
                <?= ucfirst($application['status']); ?>
            </span>
        </div>
    </div>

    <?php if (!empty($application['notes'])): ?>
        <div class="info-row">
            <div class="info-label">تێبینی:</div>
            <div class="info-value"><?= nl2br(htmlspecialchars($application['notes'])); ?></div>
        </div>
    <?php endif; ?>

    <?php if (!empty($application['file_path'])): ?>
        <iframe src="/ProcurementRequestSystem/<?= htmlspecialchars($application['file_path']); ?>" width="100%" height="400px"></iframe>
    <?php endif; ?>


<div id="app-progress">
       <h3>پڕۆسەی گەشتکردنی داواکاری:</h3>

    <?php
        $_GET['application_id'] = $application_id;
        include '../../public/get_application_progress.php';
    ?>
</div>
</div>
</body>
</html>
