<?php
require_once __DIR__ . '/../../config/db.php';
session_start();
include('../../includes/header.php');
include('../../includes/nav.php');

if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'user') {
    header('Location: ../../index.php');
    exit;
}

$user_department = '';
try {
    if (isset($_SESSION['user_id'])) {
        $stmt = $pdo->prepare("SELECT department FROM users WHERE id = :id LIMIT 1");
        $stmt->execute([':id' => $_SESSION['user_id']]);
        $user = $stmt->fetch();
        if ($user) {
            $user_department = $user['department'];
        }
    }
} catch (PDOException $e) {
    echo "Error fetching department: " . $e->getMessage();
}



?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>داشبۆردی بەکاربەر</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.css">
  <link href="https://fonts.googleapis.com/css2?family=Raleway&display=swap" rel="stylesheet">
  <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">
  <link rel="stylesheet" href="../../assets/css/layout/base.css?v=2">
  <link rel="stylesheet" href="../../assets/css/main/form.css?base.v2.css">
  <style>


  </style>
</head>
<body>
  <main class="content">

    <section>
      <div class="form-container">
        <form action="../../public/submition_application.php" method="POST" enctype="multipart/form-data">
          <div class="form-group row">
            <div class="box">
              <label for="dropdown1">ناردن بۆ</label>
              <select id="dropdown1" name="send_to" required>
                <option value="">-- هەڵبژاردن --</option>
                <option value="یاریدەدەری سەرۆکی زانکۆ">یاریدەدەری سەرۆکی زانکۆ</option>
              </select>
            </div>
            <div class="box">
              <label for="dropdown2">لە لایەن</label>
              <select id="dropdown2" name="sent_by" required>
                <option value="<?= htmlspecialchars($user_department) ?>" selected><?= htmlspecialchars($user_department) ?></option>
              </select>
            </div>
            <div class="box">
              <label for="dropdown3">بابەت</label>
              <select id="dropdown3" name="subject" required>
                <option value="">-- هەڵبژاردن --</option>
                <option value="کڕین">کڕین</option>
              </select>
            </div>
          </div>

          <div class="form-group">
            <label for="fileUpload">بارکردنی فایل:</label>
            <input type="file" id="fileUpload" name="fileUpload" required>
          </div>
          <div class="form-group">
            <label for="textarea">تێبینی:</label>
            <textarea id="textarea" name="notes" placeholder="بنووسە" required></textarea>
          </div>
          <div class="row btn-container">
            <button class="delet-btn" type="button" onclick="window.history.back();">گەڕانەوە</button>
            <button class="submit-btn" type="submit">ناردن</button>
          </div>
        </form>
      </div>
    </section>
    <?php if (isset($_GET['success']) && $_GET['success'] == 1): ?>
  <div class="custom-alert success">✅ داواکاری بەسەرکەوتووی نێردرا!</div>
<?php elseif (isset($_GET['error'])): ?>
  <?php if ($_GET['error'] === 'upload_failed'): ?>
    <div class="custom-alert error">❌ هەڵەی بارکردنی فایل. تکایە دووبارە هەوڵبدە.</div>
  <?php elseif ($_GET['error'] === 'db_error'): ?>
    <div class="custom-alert error">❌ هەڵەی داتابەیس ڕوویدا. تکایە پشتیوانی ئاگادار بکە.</div>
  <?php endif; ?>
<?php endif; ?>
  </main>
<script>
  setTimeout(() => {
    const alertBox = document.querySelector('.custom-alert');
    if (alertBox) {
      alertBox.style.opacity = '0';
      setTimeout(() => alertBox.remove(), 1000);
    }
  }, 4000);
</script>

</body>
</html>
