<?php
require_once __DIR__ . '/../../config/db.php';

session_start();
include('../../includes/header.php');  
include('../../includes/nav.php');  

if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'user') {
    header('Location: ../../index.php');
    exit;
}

$user_id = $_SESSION['user_id'];

$done_count = 0; 

$sql = "SELECT COUNT(*) AS done_count FROM submitted_applications WHERE user_id = :user_id AND status = 'done'";
$stmt = $pdo->prepare($sql);
$stmt->bindParam(':user_id', $user_id, PDO::PARAM_INT);

try {
    $stmt->execute();
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    if ($result) {
        $done_count = $result['done_count']; 
    }
} catch (PDOException $e) {
    echo "Error: " . $e->getMessage();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.css">
    <link href="https://fonts.googleapis.com/css2?family=Raleway:ital,wght@0,300;0,400;0,500;0,600;0,700;1,800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="../../assets/css/layout/base.css?v=2">
    <link rel="stylesheet" href="../../assets/css/main/cards.css?v=2">
    <link rel="stylesheet" href="../../assets/css/tables/totalAppTable.css?v=2">
    <link rel="stylesheet" href="../../assets/css/main/searchBox.css?v=2">


    <title>داشبۆردی ڕاگر</title>
    <style>
    


    </style>
</head>
<body>

    <main class="content">
        <div class="align-title-searchBox table__header">
        <h2>ئاگادارکردنەوەکان<strong>(<?php echo $done_count; ?>)</strong>
        </h2>         
        <div class="input-group">
              <input type="search" placeholder=" گەڕان...">
              <i class="fas fa-search" ></i>
            </div>
          </div>
        <section class="table__body">
            <table id="total_app" class="styled-table">
            <thead>
                    <tr>
                         <tr>
                        <th onclick="sortTable(0)"> ژمارە <i class="fa fa-sort"></i></th>
                        <th onclick="sortTable(1)"> نێردراو <i class="fa fa-sort"></i></th>
                        <th onclick="sortTable(3)"> بابەت  <i class="fa fa-sort"></i></th>
                        <th onclick="sortTable(4)"> بار <i class="fa fa-sort"></i></th>
                        <th onclick="sortTable(5)"> بەروار <i class="fa fa-sort"></i></th>
                        <th onclick="sortTable(6)"> ژمارەی ڕۆژ <i class="fa fa-sort"></i></th>

                        <th style="max-width: 60px;"> زانیاری </th>
    
                    </tr>
                    </tr>
                </thead>
                <tbody>
                <?php
try {
    $stmt = $pdo->prepare("SELECT * FROM submitted_applications");
    $stmt->execute();
    $apps = $stmt->fetchAll(PDO::FETCH_ASSOC);

    foreach ($apps as $index => $app) {
        $created_at = new DateTime($app['created_at']);
        $today = new DateTime();
        $diff = $today->diff($created_at)->days;

        echo "<tr>";
        echo "<td>" . ($index + 1) . "</td>";
        echo "<td>" . htmlspecialchars($app['sent_by']) . "</td>";
        echo "<td>" . htmlspecialchars($app['subject']) . "</td>";
        echo "<td>" . htmlspecialchars($app['status']) . "</td>";
        echo "<td>" . $created_at->format('Y-m-d') . "</td>";
        echo "<td>" . $diff . "</td>";
echo "<td><a href='view_application.php?id=" . $app['id'] . "'>وردەکاری</a></td>";
        echo "</tr>";
    }
} catch (PDOException $e) {
    echo "<tr><td colspan='8'>هەڵە لە هێنانی داتا: " . $e->getMessage() . "</td></tr>";
}
?>
</tbody>
            </table>
         
      </section>
    </main>


    <script src="../../assets/js/sortButton.js"></script>
        <script src="../../../assets/js/tableFilter.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function () {
    document.getElementById('departmentFilter').addEventListener('change', applyFilters);
    document.getElementById('decisionFilter').addEventListener('change', applyFilters);
    document.getElementById('statusFilter').addEventListener('change', applyFilters);
});
</script>
</body>
</html>
