<?php
require_once __DIR__ . '/../../config/db.php';

session_start();
include('../../includes/header.php');  
include('../../includes/nav.php');  

if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'user') {
    header('Location: ../../index.php');
    exit;
}

$user_id = $_SESSION['user_id'];

$done_count = 0; 

$sql = "SELECT COUNT(*) AS done_count FROM submitted_applications WHERE user_id = :user_id AND status = 'done'";
$stmt = $pdo->prepare($sql);
$stmt->bindParam(':user_id', $user_id, PDO::PARAM_INT);

try {
    $stmt->execute();
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    if ($result) {
        $done_count = $result['done_count']; 
    }
} catch (PDOException $e) {
    echo "Error: " . $e->getMessage();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.css">
    <link href="https://fonts.googleapis.com/css2?family=Raleway:ital,wght@0,300;0,400;0,500;0,600;0,700;1,800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="../../assets/css/layout/base.css?v=2">
    <link rel="stylesheet" href="../../assets/css/main/cards.css?v=2">
    <link rel="stylesheet" href="../../assets/css/tables/totalAppTable.css?v=2">
    <link rel="stylesheet" href="../../assets/css/main/searchBox.css?v=2">


    <title>داشبۆردی ڕاگر</title>
    <style>
    


    </style>
</head>
<body>

    <main class="content">
        <div class="align-title-searchBox table__header">
        <h2>کۆی گشتی داواکاری نەبینراو         <strong><?php echo $done_count; ?></strong>
        </h2>         
                 <!-- Filters in one row -->
  <div class="filter-row">

    <div class="filter-group">
<select class="form-select" id="decisionFilter">
    <option value="all" selected>بڕیار</option>
 <option value="پێشنیازی پەسەنکردن">پێشنیازی پەسەنکردن</option>
        <option value="پێشنیازی ڕەتکردنەوە">پێشنیازی ڕەتکردنەوە</option>
        <option value="لەئێستادا ڕابگیرێت">لەئێستادا ڕابگیرێت</option>
        <option value="پێشنیازی پەسەنکردن دوای چارەسەری تێبینی">پێشنیازی پەسەنکردن دوای چارەسەری تێبینی</option>
        <option value="لەبەر هەبوونی هەندێک تێبینی بڕیار لای بەڕێزتانە">لەبەر هەبوونی هەندێک تێبینی بڕیار لای بەڕێزتانە</option>
        <option value="دواخرا بۆ کاتێکی تر">دواخرا بۆ کاتێکی تر</option>
</select>

    </div>
       
  </div>
          </div>
        <section class="table__body">
            <table id="total_app" class="styled-table">
            <thead>
                    <tr>
                        <th onclick="sortTable(0)"> ژمارە <i class="fa fa-sort"></i></th>
                        <th onclick="sortTable(1)"> نێردراو <i class="fa fa-sort"></i></th>
                        <th onclick="sortTable(2)" style="min-width: 200px;"> کۆمێنت <i class="fa fa-sort"></i></th>
                        <th onclick="sortTable(3)"> بابەت  <i class="fa fa-sort"></i></th>
                        <th onclick="sortTable(4)"> بار <i class="fa fa-sort"></i></th>
                        <th onclick="sortTable(5)"> بەروار <i class="fa fa-sort"></i></th>
                        <th onclick="sortTable(6)"> ژمارەی ڕۆژ <i class="fa fa-sort"></i></th>

                        <th style="max-width: 60px;"> زانیاری </th>
    
                    </tr>
                </thead>
                <tbody>
                <?php
$sql = "SELECT * FROM submitted_applications WHERE user_id = :user_id AND status = 'done'";
$stmt = $pdo->prepare($sql);
$stmt->bindParam(':user_id', $user_id, PDO::PARAM_INT);

try {
    $stmt->execute();
    $applications = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    echo "<tr><td colspan='7'>Error: " . $e->getMessage() . "</td></tr>";
}

if (!empty($applications) && is_array($applications)): ?>
    <?php foreach ($applications as $application): ?>
        <tr>
            <td><?= htmlspecialchars($application['id']) ?></td>
            <td><?= htmlspecialchars($application['sent_by']) ?></td>
            <td><?= nl2br(htmlspecialchars($application['notes'])) ?></td>
            <td><?= htmlspecialchars($application['subject']) ?></td>
            <td><?= htmlspecialchars($application['status']) ?></td>
            <td><?= date("Y-m-d", strtotime($application['created_at'])) ?></td>
            <td>
                <button class="info-btn" onclick="window.location.href='viewSentApp.php?id=<?= $application['id'] ?>';">
                    <i class="fa fa-info-circle"></i>
                </button>
            </td>
        </tr>
    <?php endforeach; ?>
<?php else: ?>
    <tr><td colspan="7">No applications found.</td></tr>
<?php endif; ?>
</tbody>
            </table>
         
      </section>
    </main>


    <script src="../../assets/js/sortButton.js"></script>
        <script src="../../../assets/js/tableFilter.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function () {
    document.getElementById('departmentFilter').addEventListener('change', applyFilters);
    document.getElementById('decisionFilter').addEventListener('change', applyFilters);
    document.getElementById('statusFilter').addEventListener('change', applyFilters);
});
</script>
</body>
</html>
