<?php  
require_once __DIR__ . '/../../../config/db.php';
session_start();
include('../../../includes/header.php');  
include('../../../includes/finance_nav.php');   

if (!isset($_SESSION['userName']) || $_SESSION['role'] !== 'finance_second_admin') {
    echo "<script>alert('You must be logged in as a dean admin to access this page.'); window.location.href = '../../../index.php';</script>";
    exit;
}

$total_count = 0;

try {
    $sql = "SELECT COUNT(*) AS total_count FROM submitted_applications";
    $stmt = $pdo->prepare($sql);
    $stmt->execute();
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    if ($result) {
        $total_count = $result['total_count'];
    }
} catch (PDOException $e) {
    echo "Error: " . $e->getMessage();
}


try {
    $stmt = $pdo->query("SELECT DISTINCT department FROM users ORDER BY department ASC");
    $departments = $stmt->fetchAll(PDO::FETCH_COLUMN);
} catch (PDOException $e) {
    echo "<option>هەڵە: " . $e->getMessage() . "</option>";
    exit;
}


?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.css">
    <link href="https://fonts.googleapis.com/css2?family=Raleway:ital,wght@0,300;0,400;0,500;0,600;0,700;1,800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="../../../assets/css/layout/base.css?v=2">
    <link rel="stylesheet" href="../../../assets/css/main/cards.css?v=2">
    <link rel="stylesheet" href="../../../assets/css/tables/totalAppTable.css?v=2">
    <link rel="stylesheet" href="../../../assets/css/main/searchBox.css?v=2">


    <title>داشبۆردی بەڕێوبەراییەتی دارایی</title>
    <style>
    


    </style>
</head>
<body>

    <main class="content">
        <div class="align-title-searchBox table__header">
        <h2>کۆی گشتی داواکاری نێردراو         <strong><?php echo $total_count; ?></strong>
        </h2>         
              <!-- Filters in one row -->
  <div class="filter-row">
    <div class="filter-group">
<select class="form-select" id="departmentFilter">
    <option value="all" selected>هەموو بەڕێوبراییەتی</option>
    <?php foreach ($departments as $dept): ?>
        <option value="<?= htmlspecialchars($dept) ?>"><?= htmlspecialchars($dept) ?></option>
    <?php endforeach; ?>
</select>

    </div>
    <div class="filter-group">
<select class="form-select" id="statusFilter">
    <option value="all" selected>بار</option>
    <option value="not seen">نوێ</option>
    <option value="pending">چاوەڕوان</option>
    <option value="done">تەواو</option>
</select>

    </div>
           <div class="filter-group">
<select class="form-select" id="decisionFilter">
    <option value="all" selected>بڕیار</option>
 <option value="پێشنیازی پەسەنکردن">پێشنیازی پەسەنکردن</option>
        <option value="پێشنیازی ڕەتکردنەوە">پێشنیازی ڕەتکردنەوە</option>
        <option value="لەئێستادا ڕابگیرێت">لەئێستادا ڕابگیرێت</option>
        <option value="پێشنیازی پەسەنکردن دوای چارەسەری تێبینی">پێشنیازی پەسەنکردن دوای چارەسەری تێبینی</option>
        <option value="لەبەر هەبوونی هەندێک تێبینی بڕیار لای بەڕێزتانە">لەبەر هەبوونی هەندێک تێبینی بڕیار لای بەڕێزتانە</option>
        <option value="دواخرا بۆ کاتێکی تر">دواخرا بۆ کاتێکی تر</option>
</select>

    </div>
  </div>
          </div>
        <section class="table__body">
            <table id="total_app" class="styled-table">
            <thead>
                    <tr>
             <th onclick="sortTable(0)"> ژمارە <i class="fa fa-sort"></i></th>
                        <th onclick="sortTable(1)"> لەلایەن <i class="fa fa-sort"></i></th>
                        <th onclick="sortTable(2)"> بابەت  <i class="fa fa-sort"></i></th>
                      <th onclick="sortTable(3)"> بڕیار <i class="fa fa-sort"></i></th>
                        <th onclick="sortTable(4)"> بار <i class="fa fa-sort"></i></th>
                        <th onclick="sortTable(5)"> بەروار <i class="fa fa-sort"></i></th>
                        <th onclick="sortTable(6)"> ژمارەی ڕۆژ <i class="fa fa-sort"></i></th>

                        <th style="max-width: 60px;"> زانیاری </th>
    
    
                    </tr>
                </thead>
                 <tbody>
<?php
  $sql = "
SELECT sa.*, sau.decision, sau.previous_receiver
FROM submitted_applications sa
LEFT JOIN (
    SELECT application_id, decision, previous_receiver
    FROM application_status_updates
    WHERE id IN (
        SELECT MAX(id)
        FROM application_status_updates
        GROUP BY application_id
    )
) sau ON sa.id = sau.application_id
ORDER BY sa.created_at DESC
";

$stmt = $pdo->prepare($sql);

try {
    $stmt->execute();
    $applications = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    echo "<tr><td colspan='9'>Error: " . $e->getMessage() . "</td></tr>";
}
?>

<?php if (!empty($applications) && is_array($applications)): ?>
    <?php foreach ($applications as $application): ?>
        <tr>
<td><?= htmlspecialchars($application['id']) ?></td>
            <td><?= htmlspecialchars($application['previous_receiver']  ?? 'بەڕێوبەراییەتی دارایی') ?></td>
                        <td><?= htmlspecialchars($application['decision']) ?></td>

            <td><?= htmlspecialchars($application['subject']) ?></td>
            <td><?= htmlspecialchars($application['status']) ?></td>
            <td><?= date("Y-m-d", strtotime($application['created_at'])) ?></td>
            <td>
                <?= floor((time() - strtotime($application['created_at'])) / (60 * 60 * 24)) ?>
            </td>
            <td>
                <button class="info-btn" onclick="window.location.href='view_application.php?id=<?= $application['id'] ?>';">
                    <i class="fa fa-info-circle"></i>
                </button>
            </td>
        </tr>
    <?php endforeach; ?>
    <!-- This is the message row when no data is visible after filtering -->
<tr id="noDataRow" style="display: none;">
    <td colspan="8" style="text-align: center; color: red;">هیچ داتایەک نەدۆزرایەوە</td>
</tr>
<?php else: ?>
    <tr><td colspan="9">هیچ داواکارییەک نەدۆزرایەوە</td></tr>
<?php endif; ?>
</tbody>
           
            </table>
         
      </section>
    </main>


    <script src="../../assets/js/sortButton.js"></script>
                <script src="../../../assets/js/tableFilter.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function () {
    document.getElementById('departmentFilter').addEventListener('change', applyFilters);
    document.getElementById('decisionFilter').addEventListener('change', applyFilters);
    document.getElementById('statusFilter').addEventListener('change', applyFilters);
});
</script>

</body>
</html>
