<?php  
require_once __DIR__ . '/../../../config/db.php';
session_start();
include('../../../includes/header.php');  
include('../../../includes/finance_nav.php');   

if (!isset($_SESSION['userName']) || $_SESSION['role'] !== 'finance_second_admin') {
    echo "<script>alert('You must be logged in as a dean admin to access this page.'); window.location.href = '../../../index.php';</script>";
    exit;
}


$user_id = $_SESSION['user_id'];

$delay_apps_count = 0;

$sql = "
SELECT COUNT(*) AS delay_apps_count 
FROM application_status_updates sau
JOIN submitted_applications sa ON sau.application_id = sa.id
WHERE sau.decision = 'دواخرا بۆ کاتێکی تر'
  AND sau.new_receiver = 'user'
  AND sa.status = 'done'
";

$stmt = $pdo->prepare($sql);

try {
    $stmt->execute();
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    if ($result && isset($result['delay_apps_count'])) {
        $delay_apps_count = $result['delay_apps_count'];
    }
} catch (PDOException $e) {
    echo "Error: " . $e->getMessage();
}
try {
    $stmt = $pdo->query("SELECT DISTINCT department FROM users ORDER BY department ASC");
    $departments = $stmt->fetchAll(PDO::FETCH_COLUMN);
} catch (PDOException $e) {
    echo "<option>هەڵە: " . $e->getMessage() . "</option>";
    exit;
}

?>


<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.css">
    <link href="https://fonts.googleapis.com/css2?family=Raleway:ital,wght@0,300;0,400;0,500;0,600;0,700;1,800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="../../../assets/css/layout/base.css?v=2">
    <link rel="stylesheet" href="../../../assets/css/main/cards.css?v=2">
    <link rel="stylesheet" href="../../../assets/css/tables/totalAppTable.css?v=2">
    <link rel="stylesheet" href="../../../assets/css/main/searchBox.css?v=2">


    <title>داشبۆردی بەڕێوبەراییەتی دارایی</title>
    <style>
    


    </style>
</head>
<body>

    <main class="content">
        <div class="align-title-searchBox table__header">
        <h2>کۆی گشتی داواکاری دواخراو بۆ کاتێکی تر         <strong>(<?php echo $delay_apps_count; ?>)</strong>
        </h2>         
              <!-- Filters in one row -->
  <div class="filter-row">
    <div class="filter-group">
<select class="form-select" id="departmentFilter">
    <option value="all" selected>هەموو بەڕێوبراییەتی</option>
    <?php foreach ($departments as $dept): ?>
        <option value="<?= htmlspecialchars($dept) ?>"><?= htmlspecialchars($dept) ?></option>
    <?php endforeach; ?>
</select>

    </div>
   
  </div>
          </div>
        <section class="table__body">
            <table id="total_app" class="styled-table">
            <thead>
                    <tr>
                        <th onclick="sortTable(0)"> ژمارە <i class="fa fa-sort"></i></th>
                        <th onclick="sortTable(1)"> هاتوو <i class="fa fa-sort"></i></th>
                        <th onclick="sortTable(2)" > بڕیار <i class="fa fa-sort"></i></th>
                        <th onclick="sortTable(3)"> بابەت  <i class="fa fa-sort"></i></th>
                        <th onclick="sortTable(4)"> بار <i class="fa fa-sort"></i></th>
                        <th onclick="sortTable(5)"> بەروار <i class="fa fa-sort"></i></th>
                        <th onclick="sortTable(6)"> ژمارەی ڕۆژ <i class="fa fa-sort"></i></th>

                        <th style="max-width: 60px;"> زانیاری </th>
    
                    </tr>
                </thead>
               <tbody>
<?php
$sql = "
SELECT sau.id, sau.application_id, sa.notes, sau.decision, sau.previous_receiver, sau.created_at,
       sa.subject, sa.sent_by, sa.status, u.department
FROM application_status_updates sau
JOIN submitted_applications sa ON sau.application_id = sa.id
JOIN users u ON sa.user_id = u.id
WHERE sau.decision = 'دواخرا بۆ کاتێکی تر'
  AND sau.new_receiver = 'user'
  AND sa.status = 'done'
ORDER BY sau.created_at DESC
";

$stmt = $pdo->prepare($sql);

try {
    $stmt->execute();
    $applications = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    echo "<tr><td colspan='9'>Error: " . $e->getMessage() . "</td></tr>";
}
?>

<?php if (!empty($applications) && is_array($applications)): ?>
    <?php foreach ($applications as $application): ?>
        <tr>
            <td><?= htmlspecialchars($application['application_id']) ?></td>
            <td><?= htmlspecialchars($application['previous_receiver']) ?></td>
            <td><?= htmlspecialchars($application['decision']) ?></td>
            <td><?= htmlspecialchars($application['subject']) ?></td>
            <td><?= htmlspecialchars($application['status']) ?></td>
            <td><?= date("Y-m-d", strtotime($application['created_at'])) ?></td>
            <td>
                <?= floor((time() - strtotime($application['created_at'])) / (60 * 60 * 24)) ?>
            </td>
            <td>
                <button class="info-btn" onclick="window.location.href='view_application.php?id=<?= $application['application_id'] ?>';">
                    <i class="fa fa-info-circle"></i>
                </button>
            </td>
        </tr>
    <?php endforeach; ?>
     <!-- This is the message row when no data is visible after filtering -->
<tr id="noDataRow" style="display: none;">
    <td colspan="8" style="text-align: center; color: red;">هیچ داتایەک نەدۆزرایەوە</td>
</tr>
<?php else: ?>
    <tr><td colspan="9">هیچ داواکارییەکی پەسەندکراو نەدۆزرایەوە</td></tr>
<?php endif; ?>
</tbody>

            </table>
         
      </section>
    </main>
<script>

</script>

    <script src="../../assets/js/searchBox.js"></script>
<script src="../../../assets/js/tableFilter.js"></script>

    <script src="../../assets/js/sortButton.js"></script>
        <script>
document.addEventListener('DOMContentLoaded', function () {
    document.getElementById('departmentFilter').addEventListener('change', applyFilters);
    document.getElementById('decisionFilter').addEventListener('change', applyFilters);
    document.getElementById('statusFilter').addEventListener('change', applyFilters);
});
</script>
</body>
</html>
