<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
require_once '../../../config/db.php';
session_start();

if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    die("Invalid application ID.");
}

$application_id = (int) $_GET['id'];

// Map session role to readable Kurdish role name
$roleMap = [
    'assistant_first_admin' => 'یاریدەدەری سەرۆکی زانکۆ',
    'finance_second_admin' => 'بەڕێوبەراییەتی دارایی',
    'dean_admin' => 'سەرۆکی زانکۆ'
];

$current_role = $roleMap[$_SESSION['role']] ?? $_SESSION['role'];

try {
    // Fetch application with user email and role
    $stmt = $pdo->prepare("
        SELECT sa.*, u.email, u.department, u.role AS user_role
        FROM submitted_applications sa
        JOIN users u ON sa.user_id = u.id
        WHERE sa.id = ?
    ");
    $stmt->execute([$application_id]);
    $application = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$application) {
        die("Application not found.");
    }

} catch (PDOException $e) {
    die("Database error: " . $e->getMessage());
}
?>

<!DOCTYPE html>
<html lang="ku">
<head>
    <meta charset="UTF-8">
    <title>زانیاری دەربارەی داواکاری</title>
    <link rel="stylesheet" href="../../../assets/css/main/infoAppSection.css?v=2">
</head>
<body>
<div class="container">
    <h1>زانیاری دەربارەی داواکاری</h1>

    <div class="info-row"><div class="info-label">ژمارە:</div><div class="info-value"><?= $application['id']; ?></div></div>
    <div class="info-row"><div class="info-label">ئیمەیڵ:</div><div class="info-value"><?= htmlspecialchars($application['email']); ?></div></div>
                <div class="info-row"><div class="info-label">بەڕێوبەراییەتی:</div><div class="info-value"><?= htmlspecialchars($application['department']); ?></div></div>

    <div class="info-row"><div class="info-label">ڕۆژ:</div><div class="info-value"><?= $application['created_at']; ?></div></div>
    <div class="info-row"><div class="info-label">هاتوو:</div><div class="info-value"><?= htmlspecialchars($application['sent_by']); ?></div></div>
    <div class="info-row"><div class="info-label">بار:</div>
        <div class="info-value">
            <span class="status <?= strtolower(str_replace(' ', '-', $application['status'])); ?>">
                <?= ucfirst($application['status']); ?>
            </span>
        </div>
    </div>

    <?php if (!empty($application['notes'])): ?>
        <div class="info-row">
            <div class="info-label">تێبینی:</div>
            <div class="info-value"><?= nl2br(htmlspecialchars($application['notes'])); ?></div>
        </div>
    <?php endif; ?>

    <iframe src="../../../<?= htmlspecialchars($application['file_path']); ?>" width="100%" height="400px"></iframe>


    <!-- Only show form if current admin is the one the application is assigned to -->
    <?php if ($application['send_to'] === $current_role): ?>
    <div class="status-update-container">
        <form action="/ProcurementRequestSystem/public/first_admin_app_status.php" method="POST">
            <input type="hidden" name="application_id" value="<?= htmlspecialchars($application['id']); ?>">
            <input type="hidden" name="status" id="status" value="<?= htmlspecialchars($application['status']); ?>">

            <div class="form-group">
                <label for="decision">بڕیار</label>
                <select name="decision" id="decision" required>
                    <option value="">هەڵبژاردن</option>
                    <option value="پێشنیازی پەسەنکردن">پێشنیازی پەسەنکردن</option>
                    <option value="پێشنیازی ڕەتکردنەوە">پێشنیازی ڕەتکردنەوە</option>
                    <option value="لەئێستادا ڕابگیرێت">لەئێستادا ڕابگیرێت</option>
                    <option value="پێشنیازی پەسەنکردن دوای چارەسەری تێبینی">پێشنیازی پەسەنکردن دوای چارەسەری تێبینی</option>
                    <option value="لەبەر هەبوونی هەندێک تێبینی بڕیار لای بەڕێزتانە">لەبەر هەبوونی هەندێک تێبینی بڕیار لای بەڕێزتانە</option>
                    <option value="دواخرا بۆ کاتێکی تر">دواخرا بۆ کاتێکی تر</option>
                </select>
            </div>

            <div class="form-group">
                <label for="comment">کۆمێنت</label>
                <textarea name="comment" id="comment" rows="1" placeholder="کۆمێنتێک لەسەر داواکاری بنووسە..." class="form-textarea" required></textarea>
            </div>

            <div class="form-group">
                <label for="reassigned_to">ناردن</label>
                <select name="reassigned_to" id="reassigned_to" required>
                    <option value="">هەڵبژاردن</option>

                    <?php if ($_SESSION['role'] === 'assistant_first_admin'): ?>
                        <option value="سەرۆکی زانکۆ">سەرۆکی زانکۆ</option>
                        <option value="بەڕێوبەراییەتی دارایی">بەڕێوبەراییەتی دارایی</option>
                        <option value="user"><?= htmlspecialchars($application['email']); ?> (بەکارهێنەر)</option>
                    <?php elseif ($_SESSION['role'] === 'dean_admin'): ?>
                        <option value="یاریدەدەری سەرۆکی زانکۆ">یاریدەدەری سەرۆکی زانکۆ</option>
                    <?php elseif ($_SESSION['role'] === 'finance_second_admin'): ?>
                        <option value="یاریدەدەری سەرۆکی زانکۆ">یاریدەدەری سەرۆکی زانکۆ</option>
                        <option value="user"><?= htmlspecialchars($application['email']); ?> (بەکارهێنەر)</option>
                    <?php endif; ?>
                </select>
            </div>

            <button type="submit" class="btn-update">نوێکردنەوە</button>
        </form>
    </div>
    <?php else: ?>
        <!--<p style="color: red;">داواکاری لە بەرەوپێش بردنەوەی بەڕێوەبەرێکی ترەوەیە.</p>-->
    <?php endif; ?>
    <div id="app-progress">
       <h3>پڕۆسەی گەشتکردنی داواکاری:</h3>

    <?php
        $_GET['application_id'] = $application_id;
        include '../../../public/get_application_progress.php';
    ?>
</div>
</div>

</body>
</html>
