<?php 
require_once __DIR__ . '/config/db.php';

session_set_cookie_params([
    'httponly' => true,
    'secure' => isset($_SERVER['HTTPS']),
    'samesite' => 'Strict'
]);

session_start();

$error_message = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $userName = $_POST['userName'] ?? '';
    $password = $_POST['password'] ?? '';

    // Fetch user by username
    $stmt = $pdo->prepare("SELECT * FROM users WHERE userName = ?");
    $stmt->execute([$userName]);
    $user = $stmt->fetch();

    // If user found and password matches
    if ($user && password_verify($password, $user['password'])) {
        $_SESSION['user_id'] = $user['id'];
        $_SESSION['userName'] = $user['userName'];
        $_SESSION['role'] = $user['role'];
        $_SESSION['email']=$user['email'];
        header('Location: dashboard.php');
        exit;
    } else {
        $error_message = "ناوی بەکارهێنەر یان وشەی نهێنی هەلەیە.";
    }
}
?>


<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="assets/css/loginStyle.css?v=2">

    <title>سیستەمی دارایی ناوخۆی زانکۆی سۆران    </title>
    <style>

    </style>
</head>
<body>
    <main class="main-content">
        <div class="layout">
            <div class="above-div"> 
            <div class="img">
               <img src="assets/img/logo/UniversityLogo.png" alt="">
               </div>
               <h1>سیستەمی دارایی ناوخۆی زانکۆی سۆران</h1>
               <h1>بۆ دابینکردن و کڕینی پێداویستی </h1>

              </div>
              <div class="below-div"> 
              <form action="" method="POST"> 
              <div class="input-container">
        <input type="text" name="userName" required value="<?= htmlspecialchars($_POST['userName'] ?? '') ?>" />
                    <label class="label" for="">
                        <div class="text">ناوی بەکارهێنەر</div>
                    </label>
                </div>    
                   <div class="input-container">
                  <br>
                </div>    
                 <div class="input-container">
                    <input type="password" id="" name="password" value="<?= htmlspecialchars($_POST['password'] ?? '') ?>" required />
                    <label class="label" for="">
                        <div class="text">وشەی نهێنی</div>
                    </label>
                </div>              
                <div class="btn-container">
                    <button type="submit" class="login-btn">چوونەژوورەوە</button>
                </div>
                <?php if (!empty($error_message)): ?>
                    <p class="error-message"><?= $error_message; ?></p>
                <?php endif; ?>
        </form>

              </div>
        </div>

    </main>
<script>
document.addEventListener('DOMContentLoaded', function () {
  document.querySelectorAll('.input-container input').forEach(input => {
    const container = input.closest('.input-container');

    function updateFloating() {
      if (input.value.trim() !== '') {
        container.classList.add('floating');
      } else {
        container.classList.remove('floating');
      }
    }

    updateFloating();
    input.addEventListener('input', updateFloating);
    input.addEventListener('blur', updateFloating);
    input.addEventListener('focus', updateFloating);
  });
});
</script>


    <script>
        const input = document.getElementById('');
input.addEventListener('input', () => {
  input.setAttribute('value', input.value);
});
    </script>
</body>
</html>





