<!-- header.php -->
 <?php

try {
    // Fetch the user's department from the database
    $stmt = $pdo->prepare("SELECT department FROM users WHERE id = ?");
    $stmt->execute([$_SESSION['user_id']]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$user) {
        die("User not found.");
    }

    $user_department = $user['department'];

} catch (PDOException $e) {
    die("Database error: " . $e->getMessage());
}
?>
<header>
        <div class="head">
            <div class="logo">
            <img src="/ProcurementRequestSystem/assets/img/logo/UniversityLogo.png" alt="University logo">
            </div>
            <div class="title">
                <h1>سیستەمی دارایی ناوخۆی زانکۆی سۆران</h1>
<label for="userDepartment"> <?php echo htmlspecialchars($user_department); ?></label>
                </div>
        </div>
    </header>
