function applyFilters() {
    const selectedDept = document.getElementById('departmentFilter').value;
    const selectedDecision = document.getElementById('decisionFilter').value;
    const table = document.getElementById('total_app');
    const rows = table.querySelectorAll('tbody tr');

    rows.forEach(row => {
        const previousReceiver = row.children[1]?.textContent?.trim();
        const decision = row.children[2]?.textContent?.trim();

        const matchDept = selectedDept === 'all' || previousReceiver === selectedDept;
        const matchDecision = selectedDecision === 'all' || decision === selectedDecision;

        if (matchDept && matchDecision) {
            row.style.display = '';
        } else {
            row.style.display = 'none';
        }
    });
}

document.getElementById('departmentFilter').addEventListener('change', applyFilters);
document.getElementById('decisionFilter').addEventListener('change', applyFilters);