function sortTable(columnIndex) {
    var table = document.querySelector("table");
    var rows = Array.from(table.rows).slice(1);
    var isAscending = table.getAttribute("data-sort-order") === "asc";

    rows.sort((rowA, rowB) => {
        let cellA = rowA.cells[columnIndex].innerText.trim();
        let cellB = rowB.cells[columnIndex].innerText.trim();

        return isAscending ? cellA.localeCompare(cellB) : cellB.localeCompare(cellA);
    });

    rows.forEach(row => table.appendChild(row));

    // Toggle sorting order
    table.setAttribute("data-sort-order", isAscending ? "desc" : "asc");
}