
document.getElementById('searchInput').addEventListener('keyup', function () {
    const input = this.value.toLowerCase();
    const columnSelect = document.getElementById('columnSelect').value;
    const rows = document.querySelectorAll("#total_app tbody tr");

    rows.forEach(function (row) {
        const cells = row.getElementsByTagName("td");

        let match = false;

        if (columnSelect === "all") {
            // Check specific columns only
            const appId = cells[0]?.textContent.toLowerCase();
            const sentBy = cells[1]?.textContent.toLowerCase();
            const subject = cells[3]?.textContent.toLowerCase();

            match = appId.includes(input) || sentBy.includes(input) || subject.includes(input);
        } else {
            const columnIndex = parseInt(columnSelect);
            const cellText = cells[columnIndex]?.textContent.toLowerCase() || "";
            match = cellText.includes(input);
        }

        row.style.display = match ? "" : "none";
    });
});

